<?LassoScript

	// This include creates the navigation interface for the right side of the site administration.
	// Note that when the site is being browsed 'nav.lasso' is used instead.

	// If section and page are empty then the site preferences page is selected
	if: ((var: 'section') == '') && ((var: 'page') == '');
		'<div class="nav_one_selected"><a href="edit.lasso?mode=edit" onclick="Lasso.includeTarget(\'page_frame\', {args:this}); return false;">Site Preferences</a> &gt;</div>\r\n';
	else;
		'<div class="nav_one"><a href="edit.lasso?mode=edit" onclick="Lasso.includeTarget(\'page_frame\', {args:this}); return false;">Site Preferences</a></div>\r\n';
	/if;
	
	'<hr />\r\n';
	
	// Find all of the sections in the site
	inline: -log=$log_level,
			-search,
			-database='op_collaborate',
			-table='sections',
			-keyfield='id',
			-maxrecords='all',
			-sortfield='sort';
		records;
			var: 'nav_section_code' = (field: 'code');
			
			// Check if the current section is selected and that page is empty
			if: ((var: 'section') == (field: 'code')) && ((var: 'page') == '');
				'<div class="nav_one_selected"><a href="edit.lasso?section=' + (var: 'nav_section_code', -EncodeStrictURL) + '&amp;mode=edit" onclick="Lasso.includeTarget(\'page_frame\', {args:this}); return false;">' + (field: 'title', -EncodeHTML) + '</a> &gt;</div>\r\n';
			else;
				'<div class="nav_one"><a href="edit.lasso?section=' + (var: 'nav_section_code', -EncodeStrictURL) + '&amp;mode=edit" onclick="Lasso.includeTarget(\'page_frame\', {args:this}); return false;">' + (field: 'title', -EncodeHTML) + '</a></div>\r\n';
			/if;
			
			// If the current section is selected then show the pages within
			if: ((var: 'section') == (field: 'code'));
				inline: -log=$log_level,
						-search,
						-database='op_collaborate',
						-table='pages',
						-keyfield='id',
						-op='eq', 'section_id' = (field: 'id'),
						-maxrecords='all',
						-sortfield='sort';
					records;
						var: 'nav_page_code' = (field: 'code');
						
						// Check if the current page is selected
						if: ((var: 'page') == (field: 'code'));
							'<div class="nav_two_selected"><a href="edit.lasso?section=' + (var: 'nav_section_code', -EncodeStrictURL) + '&amp;page=' + (var: 'nav_page_code', -EncodeStrictURL) + '&amp;mode=edit" onclick="Lasso.includeTarget(\'page_frame\', {args:this}); return false;">' + (field: 'title', -EncodeHTML) + '</a> &gt;</div>\r\n';
						else;
							'<div class="nav_two"><a href="edit.lasso?section=' + (var: 'nav_section_code', -EncodeStrictURL) + '&amp;page=' + (var: 'nav_page_code', -EncodeStrictURL) + '&amp;mode=edit" onclick="Lasso.includeTarget(\'page_frame\', {args:this}); return false;">' + (field: 'title', -EncodeHTML) + '</a></div>\r\n';
						/if;
						
					/records;
				/inline;
			/if;
		/records;
	/inline;
	
	'<hr />\r\n';

	// Check if a new section is being created
	if: ((var: 'section') == '$new$');
		'<div class="nav_one_selected"><a href="edit.lasso?mode=edit&amp;section=%24new%24" onclick="Lasso.includeTarget(\'page_frame\', {args:this}); return false;">New Section</a> &gt;</div>\r\n';
	else;
		'<div class="nav_one"><a href="edit.lasso?mode=edit&amp;section=%24new%24" onclick="Lasso.includeTarget(\'page_frame\', {args:this}); return false;">New Section</a></div>\r\n';
	/if;
	
	// Check if a new page is being created
	if: ((var: 'page') == '$new$');
		'<div class="nav_two_selected"><a href="edit.lasso?mode=edit&amp;section=' + (var: 'section', -EncodeStrictURL) + '&amp;page=%24new%24" onclick="Lasso.includeTarget(\'page_frame\', {args:this}); return false;">New Page</a> &gt;</div>\r\n';
	else;
		'<div class="nav_two"><a href="edit.lasso?mode=edit&amp;section=' + (var: 'section', -EncodeStrictURL) + '&amp;page=%24new%24" onclick="Lasso.includeTarget(\'page_frame\', {args:this}); return false;">New Page</a></div>\r\n';
	/if;

?>